<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Walletobjects;

class SmartTap extends \Google\Collection
{
  protected $collection_key = 'infos';
  /**
   * The unique identifier for a smart tap. This value should follow the format
   * issuer ID.identifier where the former is issued by Google and latter is the
   * Smart Tap id. The Smart Tap id is a Base64 encoded string which represents
   * the id which was generated by the Google Pay app.
   *
   * @var string
   */
  public $id;
  protected $infosType = IssuerToUserInfo::class;
  protected $infosDataType = 'array';
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#smartTap"`.
   *
   * @deprecated
   * @var string
   */
  public $kind;
  /**
   * Smart Tap merchant ID of who engaged in the Smart Tap interaction.
   *
   * @var string
   */
  public $merchantId;

  /**
   * The unique identifier for a smart tap. This value should follow the format
   * issuer ID.identifier where the former is issued by Google and latter is the
   * Smart Tap id. The Smart Tap id is a Base64 encoded string which represents
   * the id which was generated by the Google Pay app.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Communication from merchant to user.
   *
   * @param IssuerToUserInfo[] $infos
   */
  public function setInfos($infos)
  {
    $this->infos = $infos;
  }
  /**
   * @return IssuerToUserInfo[]
   */
  public function getInfos()
  {
    return $this->infos;
  }
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#smartTap"`.
   *
   * @deprecated
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Smart Tap merchant ID of who engaged in the Smart Tap interaction.
   *
   * @param string $merchantId
   */
  public function setMerchantId($merchantId)
  {
    $this->merchantId = $merchantId;
  }
  /**
   * @return string
   */
  public function getMerchantId()
  {
    return $this->merchantId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SmartTap::class, 'Google_Service_Walletobjects_SmartTap');
