<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityPosture;

class CustomConfig extends \Google\Model
{
  /**
   * Default value. This value is unused.
   */
  public const SEVERITY_SEVERITY_UNSPECIFIED = 'SEVERITY_UNSPECIFIED';
  /**
   * Critical severity.
   */
  public const SEVERITY_CRITICAL = 'CRITICAL';
  /**
   * High severity.
   */
  public const SEVERITY_HIGH = 'HIGH';
  /**
   * Medium severity.
   */
  public const SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * Low severity.
   */
  public const SEVERITY_LOW = 'LOW';
  protected $customOutputType = CustomOutputSpec::class;
  protected $customOutputDataType = '';
  /**
   * Optional. A description of the vulnerability or misconfiguration that the
   * custom module detects. The description appears in each finding. Provide
   * enough information to help an investigator understand the finding. The
   * value must be enclosed in quotation marks.
   *
   * @var string
   */
  public $description;
  protected $predicateType = Expr::class;
  protected $predicateDataType = '';
  /**
   * Required. An explanation of the steps that security teams can take to
   * resolve the detected issue. The explanation appears in each finding.
   *
   * @var string
   */
  public $recommendation;
  protected $resourceSelectorType = ResourceSelector::class;
  protected $resourceSelectorDataType = '';
  /**
   * Required. The severity of findings generated by the custom module.
   *
   * @var string
   */
  public $severity;

  /**
   * Optional. Definitions of custom source properties to include in findings.
   *
   * @param CustomOutputSpec $customOutput
   */
  public function setCustomOutput(CustomOutputSpec $customOutput)
  {
    $this->customOutput = $customOutput;
  }
  /**
   * @return CustomOutputSpec
   */
  public function getCustomOutput()
  {
    return $this->customOutput;
  }
  /**
   * Optional. A description of the vulnerability or misconfiguration that the
   * custom module detects. The description appears in each finding. Provide
   * enough information to help an investigator understand the finding. The
   * value must be enclosed in quotation marks.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Required. The Common Expression Language (CEL) expression to evaluate. When
   * the expression evaluates to `true` for a resource, a finding is generated.
   *
   * @param Expr $predicate
   */
  public function setPredicate(Expr $predicate)
  {
    $this->predicate = $predicate;
  }
  /**
   * @return Expr
   */
  public function getPredicate()
  {
    return $this->predicate;
  }
  /**
   * Required. An explanation of the steps that security teams can take to
   * resolve the detected issue. The explanation appears in each finding.
   *
   * @param string $recommendation
   */
  public function setRecommendation($recommendation)
  {
    $this->recommendation = $recommendation;
  }
  /**
   * @return string
   */
  public function getRecommendation()
  {
    return $this->recommendation;
  }
  /**
   * Required. The resource types that the custom module operates on.
   *
   * @param ResourceSelector $resourceSelector
   */
  public function setResourceSelector(ResourceSelector $resourceSelector)
  {
    $this->resourceSelector = $resourceSelector;
  }
  /**
   * @return ResourceSelector
   */
  public function getResourceSelector()
  {
    return $this->resourceSelector;
  }
  /**
   * Required. The severity of findings generated by the custom module.
   *
   * Accepted values: SEVERITY_UNSPECIFIED, CRITICAL, HIGH, MEDIUM, LOW
   *
   * @param self::SEVERITY_* $severity
   */
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  /**
   * @return self::SEVERITY_*
   */
  public function getSeverity()
  {
    return $this->severity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CustomConfig::class, 'Google_Service_SecurityPosture_CustomConfig');
