<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowV2Sentiment extends \Google\Model
{
  /**
   * A non-negative number in the [0, +inf) range, which represents the absolute
   * magnitude of sentiment, regardless of score (positive or negative).
   *
   * @var float
   */
  public $magnitude;
  /**
   * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
   * sentiment).
   *
   * @var float
   */
  public $score;

  /**
   * A non-negative number in the [0, +inf) range, which represents the absolute
   * magnitude of sentiment, regardless of score (positive or negative).
   *
   * @param float $magnitude
   */
  public function setMagnitude($magnitude)
  {
    $this->magnitude = $magnitude;
  }
  /**
   * @return float
   */
  public function getMagnitude()
  {
    return $this->magnitude;
  }
  /**
   * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
   * sentiment).
   *
   * @param float $score
   */
  public function setScore($score)
  {
    $this->score = $score;
  }
  /**
   * @return float
   */
  public function getScore()
  {
    return $this->score;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowV2Sentiment::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowV2Sentiment');
