<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class RegexValidation extends \Google\Collection
{
  protected $collection_key = 'regexes';
  /**
   * Required. RE2 regular expressions used to validate the parameter's value.
   * The value must match the regex in its entirety (substring matches are not
   * sufficient).
   *
   * @var string[]
   */
  public $regexes;

  /**
   * Required. RE2 regular expressions used to validate the parameter's value.
   * The value must match the regex in its entirety (substring matches are not
   * sufficient).
   *
   * @param string[] $regexes
   */
  public function setRegexes($regexes)
  {
    $this->regexes = $regexes;
  }
  /**
   * @return string[]
   */
  public function getRegexes()
  {
    return $this->regexes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RegexValidation::class, 'Google_Service_Dataproc_RegexValidation');
