<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Backupdr;

class EncryptionConfig extends \Google\Model
{
  /**
   * Optional. The Cloud KMS key name to encrypt backups in this backup vault.
   * Must be in the same region as the vault. Some workload backups like compute
   * disk backups may use their inherited source key instead. Format:
   * projects/{project}/locations/{location}/keyRings/{ring}/cryptoKeys/{key}
   *
   * @var string
   */
  public $kmsKeyName;

  /**
   * Optional. The Cloud KMS key name to encrypt backups in this backup vault.
   * Must be in the same region as the vault. Some workload backups like compute
   * disk backups may use their inherited source key instead. Format:
   * projects/{project}/locations/{location}/keyRings/{ring}/cryptoKeys/{key}
   *
   * @param string $kmsKeyName
   */
  public function setKmsKeyName($kmsKeyName)
  {
    $this->kmsKeyName = $kmsKeyName;
  }
  /**
   * @return string
   */
  public function getKmsKeyName()
  {
    return $this->kmsKeyName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EncryptionConfig::class, 'Google_Service_Backupdr_EncryptionConfig');
