<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class ReturnPolicyOnline extends \Google\Collection
{
  protected $collection_key = 'returnReasonCategoryInfo';
  /**
   * The countries of sale where the return policy is applicable. The values
   * must be a valid 2 letter ISO 3166 code, e.g. "US".
   *
   * @var string[]
   */
  public $countries;
  /**
   * The item conditions that are accepted for returns. This is required to not
   * be empty unless the type of return policy is noReturns.
   *
   * @var string[]
   */
  public $itemConditions;
  /**
   * The unique user-defined label of the return policy. The same label cannot
   * be used in different return policies for the same country. Policies with
   * the label 'default' will apply to all products, unless a product specifies
   * a return_policy_label attribute.
   *
   * @var string
   */
  public $label;
  /**
   * The name of the policy as shown in Merchant Center.
   *
   * @var string
   */
  public $name;
  protected $policyType = ReturnPolicyOnlinePolicy::class;
  protected $policyDataType = '';
  protected $restockingFeeType = ReturnPolicyOnlineRestockingFee::class;
  protected $restockingFeeDataType = '';
  /**
   * The return methods of how customers can return an item. This value is
   * required to not be empty unless the type of return policy is noReturns.
   *
   * @var string[]
   */
  public $returnMethods;
  /**
   * Output only. Return policy ID generated by Google.
   *
   * @var string
   */
  public $returnPolicyId;
  /**
   * The return policy uri. This can used by Google to do a sanity check for the
   * policy.
   *
   * @var string
   */
  public $returnPolicyUri;
  protected $returnReasonCategoryInfoType = ReturnPolicyOnlineReturnReasonCategoryInfo::class;
  protected $returnReasonCategoryInfoDataType = 'array';

  /**
   * The countries of sale where the return policy is applicable. The values
   * must be a valid 2 letter ISO 3166 code, e.g. "US".
   *
   * @param string[] $countries
   */
  public function setCountries($countries)
  {
    $this->countries = $countries;
  }
  /**
   * @return string[]
   */
  public function getCountries()
  {
    return $this->countries;
  }
  /**
   * The item conditions that are accepted for returns. This is required to not
   * be empty unless the type of return policy is noReturns.
   *
   * @param string[] $itemConditions
   */
  public function setItemConditions($itemConditions)
  {
    $this->itemConditions = $itemConditions;
  }
  /**
   * @return string[]
   */
  public function getItemConditions()
  {
    return $this->itemConditions;
  }
  /**
   * The unique user-defined label of the return policy. The same label cannot
   * be used in different return policies for the same country. Policies with
   * the label 'default' will apply to all products, unless a product specifies
   * a return_policy_label attribute.
   *
   * @param string $label
   */
  public function setLabel($label)
  {
    $this->label = $label;
  }
  /**
   * @return string
   */
  public function getLabel()
  {
    return $this->label;
  }
  /**
   * The name of the policy as shown in Merchant Center.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The return policy.
   *
   * @param ReturnPolicyOnlinePolicy $policy
   */
  public function setPolicy(ReturnPolicyOnlinePolicy $policy)
  {
    $this->policy = $policy;
  }
  /**
   * @return ReturnPolicyOnlinePolicy
   */
  public function getPolicy()
  {
    return $this->policy;
  }
  /**
   * The restocking fee that applies to all return reason categories. This would
   * be treated as a free restocking fee if the value is not set.
   *
   * @param ReturnPolicyOnlineRestockingFee $restockingFee
   */
  public function setRestockingFee(ReturnPolicyOnlineRestockingFee $restockingFee)
  {
    $this->restockingFee = $restockingFee;
  }
  /**
   * @return ReturnPolicyOnlineRestockingFee
   */
  public function getRestockingFee()
  {
    return $this->restockingFee;
  }
  /**
   * The return methods of how customers can return an item. This value is
   * required to not be empty unless the type of return policy is noReturns.
   *
   * @param string[] $returnMethods
   */
  public function setReturnMethods($returnMethods)
  {
    $this->returnMethods = $returnMethods;
  }
  /**
   * @return string[]
   */
  public function getReturnMethods()
  {
    return $this->returnMethods;
  }
  /**
   * Output only. Return policy ID generated by Google.
   *
   * @param string $returnPolicyId
   */
  public function setReturnPolicyId($returnPolicyId)
  {
    $this->returnPolicyId = $returnPolicyId;
  }
  /**
   * @return string
   */
  public function getReturnPolicyId()
  {
    return $this->returnPolicyId;
  }
  /**
   * The return policy uri. This can used by Google to do a sanity check for the
   * policy.
   *
   * @param string $returnPolicyUri
   */
  public function setReturnPolicyUri($returnPolicyUri)
  {
    $this->returnPolicyUri = $returnPolicyUri;
  }
  /**
   * @return string
   */
  public function getReturnPolicyUri()
  {
    return $this->returnPolicyUri;
  }
  /**
   * The return reason category information. This required to not be empty
   * unless the type of return policy is noReturns.
   *
   * @param ReturnPolicyOnlineReturnReasonCategoryInfo[] $returnReasonCategoryInfo
   */
  public function setReturnReasonCategoryInfo($returnReasonCategoryInfo)
  {
    $this->returnReasonCategoryInfo = $returnReasonCategoryInfo;
  }
  /**
   * @return ReturnPolicyOnlineReturnReasonCategoryInfo[]
   */
  public function getReturnReasonCategoryInfo()
  {
    return $this->returnReasonCategoryInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ReturnPolicyOnline::class, 'Google_Service_ShoppingContent_ReturnPolicyOnline');
