<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class LookbackWindow extends \Google\Model
{
  /**
   * Lookback window, in days, from the last time a given user clicked on one of
   * your ads.
   *
   * @var int
   */
  public $clickDays;
  /**
   * Lookback window, in days, from the last time a given user viewed one of
   * your ads.
   *
   * @var int
   */
  public $impressionDays;

  /**
   * Lookback window, in days, from the last time a given user clicked on one of
   * your ads.
   *
   * @param int $clickDays
   */
  public function setClickDays($clickDays)
  {
    $this->clickDays = $clickDays;
  }
  /**
   * @return int
   */
  public function getClickDays()
  {
    return $this->clickDays;
  }
  /**
   * Lookback window, in days, from the last time a given user viewed one of
   * your ads.
   *
   * @param int $impressionDays
   */
  public function setImpressionDays($impressionDays)
  {
    $this->impressionDays = $impressionDays;
  }
  /**
   * @return int
   */
  public function getImpressionDays()
  {
    return $this->impressionDays;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LookbackWindow::class, 'Google_Service_DisplayVideo_LookbackWindow');
