<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidEnterprise;

class AppState extends \Google\Collection
{
  protected $collection_key = 'keyedAppState';
  protected $keyedAppStateType = KeyedAppState::class;
  protected $keyedAppStateDataType = 'array';
  /**
   * The package name of the app. This field will always be present.
   *
   * @var string
   */
  public $packageName;

  /**
   * List of keyed app states. This field will always be present.
   *
   * @param KeyedAppState[] $keyedAppState
   */
  public function setKeyedAppState($keyedAppState)
  {
    $this->keyedAppState = $keyedAppState;
  }
  /**
   * @return KeyedAppState[]
   */
  public function getKeyedAppState()
  {
    return $this->keyedAppState;
  }
  /**
   * The package name of the app. This field will always be present.
   *
   * @param string $packageName
   */
  public function setPackageName($packageName)
  {
    $this->packageName = $packageName;
  }
  /**
   * @return string
   */
  public function getPackageName()
  {
    return $this->packageName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppState::class, 'Google_Service_AndroidEnterprise_AppState');
